<!---------   
=== Theme Author : Evan Ahmed EMon
=== Theme Designed By: TWG
=== Contact Whatsapp: +8801864614704
 ----------->  
 
 <?php include 'header.php'; ?>
<div class="container-fluid">
            <?php if( $success ): ?>
          <div class="alert alert-success "><?php echo $successText; ?></div>
        <?php endif; ?>
           <?php if( $error ): ?>
          <div class="alert alert-danger "><?php echo $errorText; ?></div>
        <?php endif; ?>
   <ul class="nav nav-tabs">
        <li class="p-b">
         <button class="btn btn-default" data-toggle="modal" data-target="#modalDiv" data-action="add_remove_balance">
         <span class="export-title">Add/Remove Balance</span>
         </button>
      </li>
      
      <li class="pull-right custom-search">
         <form class="form-inline" action="<?php echo site_url("admin/payments/online") ?>" method="get">
            <div class="input-group">
               <input type="text" name="search" class="form-control" value="<?=$search_word?>" placeholder="Search ...">
               <span class="input-group-btn search-select-wrap">
                  <select class="form-control search-select" name="search_type">
                     <option value="username" <?php if( $search_where == "username" ): echo 'selected'; endif; ?> >Username</option>
                  </select>
                  <button type="submit" class="btn btn-default"><span class="fa fa-search" aria-hidden="true"></span></button>
               </span>
            </div>
         </form>
      </li>
      
   </ul>
<?php
// ডেটাবেস থেকে ডেটা ফেচ করা
$query = $conn->prepare("SELECT * FROM payments ORDER BY created_at DESC");
$query->execute();
$results = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="table-responsive">
  <table class="table table-striped table-hover">
    <thead>
      <tr>
        <th>ID</th>
        <th>Client</th>
        <th>Method</th>
        <th>Balance</th>
        <th>Amount</th>
        <th>Status</th>
        <th>Created At</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php if (!empty($results)) : ?>
        <?php foreach ($results as $row) : ?>
          <tr>
            <td><?= htmlspecialchars($row['id']) ?></td>
            <td>
              <span class="badge bg-secondary"><?= htmlspecialchars($row['cid']) ?></span> 
              <?= htmlspecialchars($row['username']) ?>
            </td>
            <td>
              <?= htmlspecialchars($row['method']) ?> 
              <?php if ($row['mode'] == 'Automatic') : ?>
                <span class="badge bg-warning text-dark">Automatic</span>
              <?php else : ?>
                <span class="badge bg-secondary">Manual</span>
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($panel_settings['site_currency_symbol']) . " " . htmlspecialchars($row['user_balance']) ?></td>
            <td><?= htmlspecialchars($panel_settings['site_currency_symbol']) . " " . htmlspecialchars($row['amount']) ?></td>
            <td><?= htmlspecialchars($row['status']) ?></td>
            <td><?= htmlspecialchars($row['created_at']) ?></td>
            <td>
              <div class="btn-group dropstart">
                <button type="button" class="btn btn-secondary dropdown-toggle btn-sm" data-bs-toggle="dropdown" aria-expanded="false">
                  Actions
                </button>
                <ul class="dropdown-menu">
                  <li><a class="dropdown-item" href="#">Details</a></li>
                </ul>
              </div>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php else : ?>
        <tr>
          <td colspan="8" class="text-center">No records found</td>
        </tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
   <?php if( $paginationArr["count"] > 1 ): ?>
     <div class="row">
        <div class="col-sm-8">
           <nav>
              <ul class="pagination">
                <?php if( $paginationArr["current"] != 1 ): ?>
                  <li class="prev"><a href="<?php echo site_url("admin/payments/online/1".$search_link) ?>">&laquo;</a></li>
                 <li class="prev"><a href="<?php echo site_url("admin/payments/online/".$paginationArr["previous"].$search_link) ?>">&lsaquo;</a></li>
                 <?php
                     endif;
                     for ($page=1; $page<=$pageCount; $page++):
                       if( $page >= ($paginationArr['current']-9) and $page <= ($paginationArr['current']+9) ):
                 ?>
                 <li class="<?php if( $page == $paginationArr["current"] ): echo "active"; endif; ?> "><a href="<?php echo site_url("admin/payments/online/".$page.$search_link) ?>"><?=$page?></a></li>
                 <?php endif; endfor;
                       if( $paginationArr["current"] != $paginationArr["count"] ):
                 ?>
                 <li class="next"><a href="<?php echo site_url("admin/payments/online/".$paginationArr["next"].$search_link) ?>" data-page="1">&rsaquo;</a></li>
                 <li class="next"><a href="<?php echo site_url("admin/payments/online/".$paginationArr["next"].$search_link) ?>" data-page="1">&raquo;</a></li>
                 <?php endif; ?>
              </ul>
           </nav>
        </div>
     </div>
   <?php endif; ?>
</div>

<?php include 'footer.php'; ?>
