<?php
if (!defined('ADDFUNDS')) {
    http_response_code(404);
    die();
}

$accessToken = $methodExtras["access_token"];
$utr = $_POST["UTR"];

if (empty($utr)) {
    errorExit("The UTR cannot be empty.");
}

if (
    !countRow([
        'table' => 'payments',
        'where' => [
            'payment_extra' => $utr
        ]
    ])
) { 
    $verifyURL = "https://modules.excelpanel.com/payment-gateways/bharatpe?action=verify_transaction&accessToken=$accessToken&utr=".$utr."&domain=".$_SERVER["HTTP_HOST"];
    $gatewayResponse =  HTTP_REQUEST($verifyURL, "", [], "GET", 0);
    $gatewayResponse = json_decode($gatewayResponse, 1);
    if($gatewayResponse["success"] == true && $gatewayResponse["transaction_status"] == "SUCCESS"){
        
        if($paymentAmount != $gatewayResponse["amount"]){
            errorExit("Invalid amount.");
        }
        
        $insert = $conn->prepare(
            "INSERT INTO payments SET
                                  client_id=:client_id,
                                  payment_amount=:amount,
                                  payment_method=:method,
                                  payment_mode=:mode,
                                  payment_create_date=:date,
                                  payment_ip=:ip,
                                  payment_extra=:extra"
        );
        $insert->execute([
            "client_id" => $user["client_id"],
            "amount" => $gatewayResponse["amount"],
            "method" => $methodId,
            "mode" => "Automatic",
            "date" => date("Y.m.d H:i:s"),
            "ip" => GetIP(),
            "extra" => $utr
        ]);

        $paymentId = $conn->lastInsertId();
        $paidAmount = floatval($gatewayResponse["amount"]);

        if ($paymentFee > 0) {

            $fee = ($paidAmount * ($paymentFee / 100));
            $paidAmount -= $fee;
        }
        if ($paymentBonusStartAmount != 0 && $paidAmount > $paymentBonusStartAmount) {
            $bonus = $paidAmount * ($paymentBonus / 100);
            $paidAmount += $bonus;
        }

        $paidAmount = from_to($currencies_array, $methodCurrency, $settings["site_base_currency"], $paidAmount);
        $update = $conn->prepare('UPDATE payments SET 
        client_balance=:balance, 
        payment_amount=:payment_amount, 
        payment_status=:status, 
        payment_delivery=:delivery WHERE payment_id=:id');
        $update->execute(
            [
                'balance' => $user['balance'],
                "payment_amount" => $paidAmount,
                'status' => 3,
                'delivery' => 2,
                'id' => $paymentId
            ]
        );
        $updateBalance = $conn->prepare("UPDATE clients SET balance=:balance WHERE client_id=:id");
        $updateBalance->execute([
            "balance" => $user["balance"] + $paidAmount,
            "id" => $user["client_id"]
        ]);
        $redirectForm .= '<script type="text/javascript">window.location.reload();</script>';

        $response["success"] = true;
        $response["message"] = "The UTR is verified and the money has been added to your account.";
        $response["content"] = $redirectForm;
        
    } else {
        errorExit($gatewayResponse["message"]);
    }
} else {
    errorExit("This UTR is already used.");
}