<?php include 'admin_security.php'; ?>
<!-- Threat Modal -->
<div id="threatModal" class="fixed inset-0 bg-black bg-opacity-75 hidden items-center justify-center z-50 p-4">
    <div class="bg-red-900 text-white rounded-lg p-6 max-w-md w-full animate-shake">
        <div class="flex items-center mb-4">
            <i class="fas fa-radiation fa-2x mr-3"></i>
            <h3 class="text-2xl font-bold">SECURITY ALERT</h3>
        </div>
        
        <p class="mb-4">
            ⚠️ <span class="font-semibold">FINAL WARNING: From MR </span> Unauthorized access attempt detected. 
            Your IP <span class="font-mono"><?= $ip ?></span> and device fingerprint have been logged.
        </p>

        <div class="bg-black p-3 rounded mb-4">
            <p class="text-sm">
                <span class="font-bold">Next attempt will:</span><br>
                1. Permanently suspend all associated accounts<br>
                2. Deduct all your balance for security fee<br>
                3. Report to authorities
            </p>
        </div>

        <div class="grid gap-2">
            <button onclick="window.location.href='/'" class="bg-white text-red-900 p-2 rounded font-bold hover:bg-red-100">
                <i class="fas fa-home mr-2"></i>Exit Immediately
            </button>
            <button onclick="window.close()" class="border-2 border-white p-2 rounded hover:bg-red-800">
                <i class="fas fa-power-off mr-2"></i>MotherFucker
            </button>
        </div>
    </div>
</div>

<script>
// Show modal on error
<?php if($error): ?>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('threatModal');
    modal.classList.remove('hidden');
    
    // Prevent closing
    modal.addEventListener('click', (e) => {
        if(e.target === modal) e.preventDefault();
    });

    // Block right-click
    document.addEventListener('contextmenu', (e) => {
        e.preventDefault();
        return false;
    });
});
<?php endif; ?>
</script>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Panel - Secure Login</title>
    <!-- Favicon Link -->
    <link rel="icon" href="https://i.postimg.cc/CMQMWCwY/favicon-nethussnain.webp" type="image/x-icon"> 
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Space+Grotesk:wght@500;700&display=swap" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        :root {
            --primary-color: #4f46e5;
            --secondary-color: #818cf8;
            --success-color: #10b981;
            --danger-color: #ef4444;
            --background-light: #ffffff;
            --background-dark: #151521;
            --card-dark: #1E1E2D;
            --text-light: #1f2937;
            --text-dark: #f3f4f6;
            --dark-input: #2B2B40;
            --dark-hover: #323248;
            --dark-focus: #3b82f6;
            --button-blue: #3992FF;
        }

        html.dark {
            background: var(--background-dark);
        }

        body {
            font-family: 'Poppins', sans-serif;
            transition: all 0.3s ease;
            min-height: 100vh;
            margin: 0;
            padding: 0;
        }

        body.dark {
            background: var(--background-dark);
            color: var(--text-dark);
        }

        .min-h-screen {
            min-height: 100vh;
            width: 100%;
            transition: background-color 0.3s ease;
        }

        .dark .min-h-screen {
            background: var(--background-dark);
        }

        .glass-effect {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px rgba(31, 38, 135, 0.15);
        }

        .dark .glass-effect {
            background: var(--card-dark);
            border: 1px solid rgba(255, 255, 255, 0.05);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.25);
        }

        .dark .input-focus {
            background: var(--dark-input) !important;
            border: 1px solid rgba(255, 255, 255, 0.05) !important;
            color: #ffffff !important;
        }

        /* Update the background pattern for dark mode */
        .bg-pattern {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1;
        }

        .dark .bg-pattern {
            background-image: 
                radial-gradient(circle at 25px 25px, rgba(255, 255, 255, 0.02) 2%, transparent 0%),
                radial-gradient(circle at 75px 75px, rgba(255, 255, 255, 0.02) 2%, transparent 0%);
            background-size: 100px 100px;
            opacity: 1;
        }

        /* Update button style */
        .dark .btn-primary {
            background: #7B6EF6;
            box-shadow: 0 4px 15px rgba(123, 110, 246, 0.25);
        }

        .dark .btn-primary:hover {
            background: #8A7EF7;
            box-shadow: 0 8px 24px rgba(123, 110, 246, 0.35);
            transform: translateY(-1px);
        }

        /* Update caution container for dark mode */
        .dark .caution-container {
            background: rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        /* Ensure proper text color in dark mode */
        .dark .text-gray-500,
        .dark .text-gray-600,
        .dark .text-gray-700 {
            color: rgba(255, 255, 255, 0.7);
        }

        .dark .text-gray-900 {
            color: #ffffff;
        }

        h2, .heading-font {
            font-family: 'Space Grotesk', sans-serif;
            letter-spacing: -0.03em;
        }

        body.dark {
            background: var(--background-dark);
            color: var(--text-dark);
        }

        .glass-effect {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px rgba(31, 38, 135, 0.15);
        }

        .dark .glass-effect {
            background: var(--card-dark);
            border: 1px solid rgba(255, 255, 255, 0.05);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.25);
        }

        .input-focus {
            transition: all 0.3s ease;
            font-weight: 400;
        }

        .dark .input-focus::placeholder {
            color: rgba(255, 255, 255, 0.5) !important;
        }

        .btn-primary {
            background: var(--button-blue);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            font-weight: 500;
            letter-spacing: 0.5px;
            text-transform: uppercase;
            font-size: 0.875rem;
            border: none;
        }

        .theme-toggle {
            position: fixed;
            top: 1rem;
            right: 1rem;
            z-index: 50;
            padding: 0.75rem;
            border-radius: 9999px;
            background: rgba(255, 255, 255, 0.9);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .dark .theme-toggle {
            background: rgba(43, 43, 64, 0.95);
            color: var(--text-dark);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .alert {
            animation: slideIn 0.5s ease-out;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            font-weight: 400;
        }

        .dark .alert {
            background: rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .dark .bg-green-50 {
            background-color: rgba(16, 185, 129, 0.1);
            border-color: rgba(16, 185, 129, 0.2);
        }

        .dark .bg-red-50 {
            background-color: rgba(239, 68, 68, 0.1);
            border-color: rgba(239, 68, 68, 0.2);
        }

        .form-group {
            position: relative;
            margin-bottom: 1.5rem;
        }

        .form-group::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 2px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .dark .form-group::after {
            display: none;
        }

        .input-icon {
            color: var(--primary-color);
            transition: all 0.3s ease;
        }

        .dark .input-icon {
            color: rgba(255, 255, 255, 0.7);
        }

        .page-title {
            background: linear-gradient(135deg, #4f46e5 0%, #818cf8 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .dark .page-title {
            color: #ffffff;
            background: none;
            -webkit-text-fill-color: #ffffff;
        }

        .subtitle {
            font-weight: 400;
            opacity: 0.8;
            font-size: 0.95rem;
        }

        .dark .subtitle {
            color: rgba(255, 255, 255, 0.7);
        }

        @keyframes slideIn {
            from {
                transform: translateY(-100%);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* Decorative Elements */
        .logo-text {
            font-family: 'Space Grotesk', sans-serif;
            font-weight: 700;
            letter-spacing: -0.05em;
            background: linear-gradient(135deg, #4f46e5 0%, #818cf8 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-shadow: 0px 2px 4px rgba(0, 0, 0, 0.1);
        }

        /* Typing Effect Styles */
        .typewriter-text {
            display: inline-flex;
            align-items: center;
            font-family: 'Space Grotesk', monospace;
            opacity: 0.9;
            font-size: 0.75rem;
            white-space: nowrap;
            max-width: 100%;
            overflow: hidden;
        }

        .typewriter-text i {
            animation: pulse 2s infinite;
            font-size: 0.75rem;
        }

        @keyframes pulse {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }

        .cursor {
            display: inline-block;
            width: 2px;
            height: 1em;
            background: currentColor;
            margin-left: 2px;
            animation: cursor-blink 1s infinite;
        }

        @keyframes cursor-blink {
            0% { opacity: 1; }
            50% { opacity: 0; }
            100% { opacity: 1; }
        }

        /* Update the container for better spacing */
        .caution-container {
            margin-top: 1rem;
            padding: 0.5rem;
            border-radius: 0.375rem;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(4px);
        }

        .dark .caution-container {
            background: rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .dark .typewriter-text {
            color: rgba(255, 255, 255, 0.7);
        }

        .dark .text-yellow-500 {
            color: #fbbf24;
        }

        /* Logo container in dark mode */
        .dark .logo-container {
            background: #7B6EF6;
            box-shadow: 0 8px 24px rgba(123, 110, 246, 0.25);
        }

        /* Add subtle hover effect to card in dark mode */
        .dark .glass-effect:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.3);
            transition: all 0.3s ease;
        }
        /* Shake animation */
@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-10px); }
    75% { transform: translateX(10px); }
}

.animate-shake {
    animation: shake 0.5s cubic-bezier(.36,.07,.19,.97) infinite;
}

/* Security cursor */
body.threat-mode {
    cursor: url("data:image/svg+xml,%3Csvg...") 16 16, auto;
}
    </style>
</head>
<body class="min-h-screen">
    <div class="bg-pattern"></div>

    <button id="themeToggle" class="theme-toggle">
        <i class="fas fa-sun dark:hidden"></i>
        <i class="fas fa-moon hidden dark:block"></i>
    </button>

    <div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8 glass-effect p-8 rounded-xl">
            <div>
                <div class="flex justify-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-indigo-500 to-purple-500 rounded-full flex items-center justify-center shadow-lg transform hover:scale-105 transition-transform duration-300 logo-container">
                        <i class="fas fa-shield-alt text-white text-2xl"></i>
                    </div>
                </div>
                <h2 class="mt-6 text-center text-3xl font-bold page-title">
                    MR REntal
                </h2>
                <p class="mt-2 text-center subtitle text-gray-600 dark:text-gray-400">
                    Secure Admin Login
                </p>
            </div>

            <?php if( $success ): ?>
            <div class="alert bg-green-50 text-green-700 p-3 mb-4"><?php echo $successText; ?></div>
            <?php endif; ?>
            
            <?php if( $error ): ?>
            <div class="alert bg-red-50 text-red-700 p-3 mb-4"><?php echo $errorText; ?></div>
            <?php endif; ?>

            <form id="loginForm" action="#" method="post" class="mt-8 space-y-6">
                <div class="space-y-4">
                    <!-- Username Field -->
                    <div class="form-group">
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-user text-gray-400 input-icon"></i>
                            </div>
                            <input id="username" name="username" type="text" required 
                                class="appearance-none relative block w-full px-3 py-3 pl-10 border border-gray-200 placeholder-gray-500 text-gray-900 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent sm:text-sm input-focus dark:bg-gray-800 dark:border-gray-700 dark:text-white"
                                placeholder="Enter Username">
                        </div>
                    </div>

                    <!-- Password Field -->
                    <div class="form-group">
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-key text-gray-400 input-icon"></i>
                            </div>
                            <input id="password" name="password" type="password" required 
                                class="appearance-none relative block w-full px-3 py-3 pl-10 border border-gray-200 placeholder-gray-500 text-gray-900 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent sm:text-sm input-focus dark:bg-gray-800 dark:border-gray-700 dark:text-white"
                                placeholder="Password">
                            <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                                <button type="button" onclick="togglePassword()" class="text-gray-400 hover:text-gray-500 transition-colors">
                                    <i class="fas fa-eye" id="toggleIcon"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Two-Factor Code Field -->
                    <div class="form-group">
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i class="fas fa-unlock text-gray-400 input-icon"></i>
                            </div>
                            <input id="two_factor_code" name="two_factor_code" type="number" 
                                class="appearance-none relative block w-full px-3 py-3 pl-10 border border-gray-200 placeholder-gray-500 text-gray-900 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent sm:text-sm input-focus dark:bg-gray-800 dark:border-gray-700 dark:text-white"
                                placeholder="2FA Code (If Enabled)">
                        </div>
                    </div>
                </div>

                <div>
                    <button type="submit" 
                        class="group relative w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-lg text-white btn-primary focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <span class="absolute left-0 inset-y-0 flex items-center pl-3">
                            <i class="fas fa-shield"></i>
                        </span>
                        Secure Login
                    </button>

                    <div class="mt-4 text-center caution-container">
                        <p class="typewriter-text text-gray-500 dark:text-gray-400" dir="ltr">
                            <i class="fas fa-exclamation-triangle text-yellow-500 mr-1"></i>
                            <span id="cautionText"></span>
                        </p>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        // Password Toggle Function
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const toggleIcon = document.getElementById('toggleIcon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
            }
        }

        // Theme Toggle Function
        const themeToggle = document.getElementById('themeToggle');
        const html = document.documentElement;
        
        // Check for saved theme preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            html.classList.add('dark');
        } else {
            html.classList.remove('dark');
        }

        themeToggle.addEventListener('click', () => {
            if (html.classList.contains('dark')) {
                html.classList.remove('dark');
                localStorage.theme = 'light';
            } else {
                html.classList.add('dark');
                localStorage.theme = 'dark';
            }
        });

        // Form Submission Security
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            
            // Basic validation
            if (username.length < 3 || password.length < 8) {
                e.preventDefault();
                alert('Please enter valid credentials');
                return false;
            }
        });

        // Typing Effect for Caution Note with fixed English text
        function typeWriter(text, element, speed = 50) {
            let i = 0;
            element.innerHTML = ''; // Clear existing text
            
            // Create cursor element
            const cursor = document.createElement('span');
            cursor.className = 'cursor';
            element.parentNode.appendChild(cursor);

            function type() {
                if (i < text.length) {
                    element.innerHTML += text.charAt(i);
                    i++;
                    setTimeout(type, speed);
                }
            }

            type();
        }

        // Initialize typing effect with fixed English text
        document.addEventListener('DOMContentLoaded', function() {
            const cautionText = document.getElementById('cautionText');
            const message = "Failed login attempts will lock your account";
            
            // Set text direction and language
            cautionText.setAttribute('dir', 'ltr');
            cautionText.setAttribute('lang', 'en');
            
            // Initial typing effect
            typeWriter(message, cautionText, 40);

            // Restart animation every 12 seconds
            setInterval(() => {
                typeWriter(message, cautionText, 40);
            }, 12000);
        });
    </script>
</body>
</html>